/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public class NodeTileEntity
extends GenericTileEntity {
    @GuiValue
    private String channel;
    @GuiValue
    private String node;
    private BlockPos processor = null;
    private int prevIn = 0;
    private final int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Node").containerSupplier(DefaultContainerProvider.empty(VariousModule.NODE_CONTAINER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public NodeTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VariousModule.NODE_TILE.get(), pos, state);
    }

    public String getNodeName() {
        return this.node;
    }

    public String getChannelName() {
        return this.channel;
    }

    public void setChannelName(String channel) {
        this.channel = channel;
        this.m_6596_();
    }

    public void setNodeName(String node) {
        this.node = node;
        this.m_6596_();
    }

    public BlockPos getProcessor() {
        return this.processor;
    }

    public void setProcessor(BlockPos processor) {
        this.processor = processor;
        this.m_6596_();
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            BlockEntity te;
            if (this.processor != null && (te = this.m_58904_().m_7702_(this.processor)) instanceof ProcessorTileEntity) {
                ProcessorTileEntity processor = (ProcessorTileEntity)te;
                processor.redstoneNodeChange(this.prevIn, powered, this.node);
            }
            this.prevIn = powered;
        }
        super.setPowerInput(powered);
    }

    public int getPowerOut(Direction side) {
        return this.powerOut[side.ordinal()];
    }

    public void setPowerOut(Direction side, int powerOut) {
        this.powerOut[side.ordinal()] = powerOut;
        this.m_6596_();
        this.m_58904_().m_46586_(this.f_58858_.m_142300_(side), this.m_58900_().m_60734_(), this.f_58858_);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.prevIn = tagCompound.m_128451_("prevIn");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.m_128445_("p" + i);
        }
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.channel = info.m_128461_("channel");
        this.node = info.m_128461_("node");
        this.processor = BlockPosTools.read((CompoundTag)info, (String)"processor");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128405_("prevIn", this.prevIn);
        for (int i = 0; i < 6; ++i) {
            tagCompound.m_128344_("p" + i, (byte)this.powerOut[i]);
        }
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        if (this.channel != null) {
            info.m_128359_("channel", this.channel);
        }
        if (this.node != null) {
            info.m_128359_("node", this.node);
        }
        if (this.processor != null) {
            BlockPosTools.write((CompoundTag)info, (String)"processor", (BlockPos)this.processor);
        }
    }
}

